/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import panther.util.general.Bag;
import panther.util.general.Base64Decode;
import panther.util.general.Base64Encode;
import panther.util.general.CollectionUtils;
import panther.util.general.MathUtils;
import pse.util.general.SimplePair;
import pse.util.general.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static List afterFirstWord(String string) {
        List list = StringUtils.asTokens(string);
        return list.isEmpty() ? new ArrayList() : list.subList(1, list.size());
    }

    public static boolean anyLinesStart(String string, String string2) {
        return StringUtils.anyLinesStart(string, string2, false);
    }

    public static boolean anyLinesStart(String string, String string2, boolean bl) {
        int n = 0;
        int n2 = string.indexOf("\n");
        while (n < string.length()) {
            String string3;
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if (bl) {
                for (n3 = n; n3 < n2 && Character.isWhitespace(string.charAt(n3)); ++n3) {
                }
            }
            if ((string3 = string.substring(n3, n2)).startsWith(string2)) {
                return true;
            }
            n = n2 + 1;
            n2 = string.indexOf("\n", n);
        }
        return false;
    }

    public static List asTokens(String string) {
        return CollectionUtils.asList(new StringTokenizer(string));
    }

    public static List asTokens(String string, String string2) {
        return CollectionUtils.asList(new StringTokenizer(string, string2));
    }

    public static List asTokens2(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) {
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + string.charAt(i);
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean between(String string, String string2, String string3) {
        return string2.startsWith(string) && string3.startsWith(string2);
    }

    public static boolean betweenIgnoreCase(String string, String string2, String string3) {
        return StringUtils.startsWithIgnoreCase(string2, string) && StringUtils.startsWithIgnoreCase(string3, string2);
    }

    public static String capitalize(String string) {
        String string2 = string;
        if (string != null && string.length() > 0) {
            char c = Character.toUpperCase(string.charAt(0));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            if (string.length() > 1) {
                stringBuffer.append(string.substring(1));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String checkIsNull(String string, String string2) {
        String string3 = null;
        string3 = string == null ? string2 : string;
        return string3;
    }

    public static String concatenate(List list) {
        return StringUtils.concatenate(list, " ");
    }

    public static String concatenate(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString();
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.concatenate(objectArray, " ");
    }

    public static String concatenate(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static boolean containsAll(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (string.indexOf((String)list.get(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (string.indexOf((String)list.get(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String string, String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            if (string.indexOf(string2.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(String string, String[] stringArray) {
        if (string == null || string.length() == 0 || stringArray == null || stringArray.length == 0) {
            return false;
        }
        String string2 = string.toLowerCase();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            if (stringArray[i] == null || string2.indexOf(string3 = stringArray[i].toLowerCase()) < 0) continue;
            return true;
        }
        return false;
    }

    public static String copyNoWhiteSpace(String string) {
        return string.replace(" ", "").replace("\n", "").replace("\r", "").replace("\t", "");
    }

    public static String copyWithout(String string, String string2) {
        return StringUtils.replaceAll(string, string2, "");
    }

    public static int countAtStart(String string, char c) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            return i;
        }
        return string.length();
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        return string.toLowerCase().endsWith(string2.toLowerCase());
    }

    public static boolean equalsAny(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreWhiteSpace(String string, String string2) {
        return StringUtils.copyNoWhiteSpace(string).equals(StringUtils.copyNoWhiteSpace(string2));
    }

    public static String filledString(char c, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static String findCommonPrefix(List list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String string = (String)list.get(0);
        if (list.size() == 1) {
            return string;
        }
        for (int i = 1; i < string.length(); ++i) {
            String string2 = string.substring(0, i);
            for (int j = 1; j < list.size(); ++j) {
                String string3 = (String)list.get(j);
                if (string3.startsWith(string2)) continue;
                return string.substring(0, i - 1);
            }
        }
        return string;
    }

    public static String findCommonPrefix(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return "";
        }
        if (string.charAt(0) != string2.charAt(0)) {
            return "";
        }
        int n = Math.min(string.length(), string2.length());
        for (int i = 1; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return string.substring(0, i - 1);
        }
        return string.length() > string2.length() ? string2 : string;
    }

    public static int firstDifferencePoint(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (i >= string2.length()) {
                return i;
            }
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        if (string2.length() > string.length()) {
            return string.length();
        }
        return -1;
    }

    public static SimplePair<String, String> firstSplit(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return new SimplePair<String, Object>(string, null);
        }
        return new SimplePair<String, String>(string.substring(0, n), string.substring(n + string2.length()));
    }

    public static String firstWord(String string) {
        List list = StringUtils.asTokens(string);
        return list.isEmpty() ? "" : (String)list.get(0);
    }

    public static String formatTime(long l, long l2, long l3) {
        return l + ":" + StringUtils.twoDigit(l2) + ":" + StringUtils.twoDigit(l3);
    }

    public static String formatTimeInMilliseconds(long l) {
        long l2 = l / 1000L;
        long l3 = l2 % 60L;
        long l4 = l2 / 60L % 60L;
        long l5 = l2 / 3600L;
        return StringUtils.formatTime(l5, l4, l3);
    }

    public static String insertBefore(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new Error("[" + string2 + "] not found in [" + string + "]");
        }
        return string.substring(0, n) + string3 + string.substring(n);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String leftJustify(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl = true;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (bl) {
                    if (c == '\n' || !Character.isWhitespace(c)) {
                        bl = false;
                        continue;
                    }
                    ++n;
                    continue;
                }
                stringBuffer.append(c);
                if (c == '\n') {
                    bl = true;
                }
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static boolean nonEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean nullableStringsEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static int numberOfOccurrences(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static String pad(int n, int n2) {
        return StringUtils.pad(String.valueOf(n), n2);
    }

    public static String pad(Object object) {
        return StringUtils.pad(object == null ? "" : object.toString());
    }

    public static String pad(Object object, int n) {
        return StringUtils.pad(object == null ? "" : object.toString(), n);
    }

    public static String pad(String string) {
        return StringUtils.pad(string, 8);
    }

    public static String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String padAfter(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String padBefore(int n, int n2, String string) {
        return StringUtils.padBefore(String.valueOf(n), n2, string);
    }

    public static String padBefore(long l, int n, String string) {
        return StringUtils.padBefore(String.valueOf(l), n, string);
    }

    public static String padBefore(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, string2);
        }
        return stringBuffer.toString();
    }

    public static String printBag(Bag bag) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtils.printBag(bag, stringBuilder);
        return stringBuilder.toString();
    }

    public static void printBag(Bag bag, StringBuilder stringBuilder) {
        int n = MathUtils.getNumberOfDigits(bag.getMaximumOccurrences()) + 1;
        Iterator iterator = bag.sortedIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n2 = bag.occurrencesOf(string);
            stringBuilder.append(StringUtils.padBefore(String.valueOf(n2), n, " "));
            stringBuilder.append("\t");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
    }

    public static String regularizeWhiteSpace(String string) {
        String string2 = string.trim();
        string2 = StringUtils.replaceAll(string2, "\n", " ");
        string2 = StringUtils.replaceAll(string2, "\t", " ");
        while (string2.indexOf("  ") > 0) {
            string2 = StringUtils.replaceAll(string2, "  ", " ");
        }
        return string2;
    }

    public static String removeLinesStarting(String string, String string2) {
        return StringUtils.removeLinesStarting(string, string2, false);
    }

    public static String removeLinesStarting(String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.indexOf("\n");
        while (n < string.length()) {
            String string3;
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if (bl) {
                for (n3 = n; n3 < n2 && Character.isWhitespace(string.charAt(n3)); ++n3) {
                }
            }
            if (!(string3 = string.substring(n3, n2)).startsWith(string2)) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append("\n");
            }
            n = n2 + 1;
            n2 = string.indexOf("\n", n);
        }
        return stringBuilder.toString();
    }

    public static String removeWhiteSpace(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = string.replaceAll(" ", "");
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        return string2;
    }

    public static String replaceAll(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n < string.length() && n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String replaceBetween(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        int n = string.indexOf(string2);
        if (n < 0) {
            if (!bl) throw new Error("[" + string2 + "] not found in [" + string + "]");
            n = 0;
        } else {
            n += string2.length();
        }
        int n2 = string.indexOf(string3, n);
        if (n2 >= 0) return string.substring(0, n) + string4 + string.substring(n2, string.length());
        if (!bl2) throw new Error("[" + string3 + "] not found in [" + string + "] after [" + string2 + "]");
        n2 = string.length();
        return string.substring(0, n) + string4 + string.substring(n2, string.length());
    }

    public static String replaceLinesStarting(String string, String string2, String string3) {
        return StringUtils.replaceLinesStarting(string, string2, string3, false);
    }

    public static String replaceLinesStarting(String string, String string2, String string3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        int n = 0;
        int n2 = string.indexOf("\n");
        while (n < string.length()) {
            String string4;
            int n3;
            if (n2 < 0) {
                n2 = string.length();
            }
            if (bl) {
                for (n3 = n; n3 < n2 && Character.isWhitespace(string.charAt(n3)); ++n3) {
                }
            }
            if (!(string4 = string.substring(n3, n2)).startsWith(string2)) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append("\n");
            } else if (!bl2) {
                stringBuilder.append(string3);
                bl2 = true;
            }
            n = n2 + 1;
            n2 = string.indexOf("\n", n);
        }
        return stringBuilder.toString();
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public static String substringAfter(String string, String string2) {
        return StringUtils.substringAfterLast(string, string2);
    }

    public static String substringAfterFirst(String string, String string2) {
        int n = string.indexOf(string2);
        return n == -1 ? string : string.substring(n + string2.length());
    }

    public static String substringAfterLast(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return n == -1 ? string : string.substring(n + string2.length());
    }

    public static String substringBefore(String string, String string2) {
        return StringUtils.substringBeforeFirst(string, string2);
    }

    public static String substringBeforeFirst(String string, String string2) {
        int n = string.indexOf(string2);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String substringBeforeLast(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String substringBetween(String string, String string2, String string3) {
        return StringUtils.substringBetween(string, string2, string3, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String substringBetween(String string, String string2, String string3, boolean bl, boolean bl2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            if (!bl) return null;
            n = 0;
        } else {
            n += string2.length();
        }
        int n2 = string.indexOf(string3, n);
        if (n2 >= 0) return string.substring(n, n2);
        if (!bl2) return null;
        n2 = string.length();
        return string.substring(n, n2);
    }

    public static String toBase64DecodedString(String string) throws Exception {
        return new String(Base64Decode.decode(string), "utf-8");
    }

    public static String toBase64EncodedString(String string) throws Exception {
        return Base64Encode.encode(string);
    }

    public static String toHexString(byte[] byArray) {
        return Utilities.encodeHex(byArray);
    }

    public static String[] trueSplit(String string, char c) {
        int n = StringUtils.numberOfOccurrences(string, c);
        if (!string.endsWith("\n")) {
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(c, n3);
        while (n4 >= 0) {
            stringArray[n2++] = string.substring(n3, n4);
            n3 = n4 + 1;
            n4 = string.indexOf(c, n3);
        }
        if (n3 < string.length()) {
            stringArray[n2] = string.substring(n3);
        }
        return stringArray;
    }

    public static String twoDigit(long l) {
        if (l == 0L) {
            return "00";
        }
        if (l > 0L && l < 10L) {
            return "0" + l;
        }
        return String.valueOf(l);
    }

    public static String withoutLeading(String string, char c) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        for (n = 0; n < string.length() && string.charAt(n) == c; ++n) {
        }
        return string.substring(n, string.length());
    }

    public static String withoutTrailing(String string, char c) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == c; --n) {
        }
        return string.substring(0, n + 1);
    }
}

